#ifdef __cplusplus
extern "C" {
#endif

#ifndef TEX8BENC_H
#define TEX8BENC_H

/* UCS -> T1 mapping table */
static unsigned short UCStoT1enc[] = {
    /* from,  to */
    0xA1,    0xBD,
    0xA3,    0xBF,
    0xA7,    0x9F,
    0xA8,    0x04,
    0xAB,    0x13,
    0xAF,    0x09,
    0xB4,    0x01,
    0xB8,    0x0B,
    0xBB,    0x14,
    0xBF,    0xBE,
    0xC0,    0xC0,  // LATIN CAPITAL LETTER A WITH GRAVE
    0xC1,    0xC1,  // LATIN CAPITAL LETTER A WITH ACUTE
    0xC2,    0xC2,  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0xC3,    0xC3,  // LATIN CAPITAL LETTER A WITH TILDE
    0xC4,    0xC4,  // LATIN CAPITAL LETTER A WITH DIAERESIS
    0xC5,    0xC5,  // LATIN CAPITAL LETTER A WITH RING ABOVE
    0xC6,    0xC6,  // LATIN CAPITAL LETTER AE
    0xC7,    0xC7,  // LATIN CAPITAL LETTER C WITH CEDILLA
    0xC8,    0xC8,  // LATIN CAPITAL LETTER E WITH GRAVE
    0xC9,    0xC9,  // LATIN CAPITAL LETTER E WITH ACUTE
    0xCA,    0xCA,  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0xCB,    0xCB,  // LATIN CAPITAL LETTER E WITH DIAERESIS
    0xCC,    0xCC,  // LATIN CAPITAL LETTER I WITH GRAVE
    0xCD,    0xCD,  // LATIN CAPITAL LETTER I WITH ACUTE
    0xCE,    0xCE,  // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0xCF,    0xCF,  // LATIN CAPITAL LETTER I WITH DIAERESIS
    0xD0,    0xD0,  // LATIN CAPITAL LETTER ETH
    0xD1,    0xD1,  // LATIN CAPITAL LETTER N WITH TILDE
    0xD2,    0xD2,  // LATIN CAPITAL LETTER O WITH GRAVE
    0xD3,    0xD3,  // LATIN CAPITAL LETTER O WITH ACUTE
    0xD4,    0xD4,  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0xD5,    0xD5,  // LATIN CAPITAL LETTER O WITH TILDE
    0xD6,    0xD6,  // LATIN CAPITAL LETTER O WITH DIAERESIS
    0xD8,    0xD8,  // LATIN CAPITAL LETTER O WITH STROKE
    0xD9,    0xD9,  // LATIN CAPITAL LETTER U WITH GRAVE
    0xDA,    0xDA,  // LATIN CAPITAL LETTER U WITH ACUTE
    0xDB,    0xDB,  // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0xDC,    0xDC,  // LATIN CAPITAL LETTER U WITH DIAERESIS
    0xDD,    0xDD,  // LATIN CAPITAL LETTER Y WITH ACUTE
    0xDE,    0xDE,  // LATIN CAPITAL LETTER THORN
    0xDF,    0xFF,  // LATIN SMALL LETTER SHARP S
    0xE0,    0xE0,  // LATIN SMALL LETTER A WITH GRAVE
    0xE1,    0xE1,  // LATIN SMALL LETTER A WITH ACUTE
    0xE2,    0xE2,  // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0xE3,    0xE3,  // LATIN SMALL LETTER A WITH TILDE
    0xE4,    0xE4,  // LATIN SMALL LETTER A WITH DIAERESIS
    0xE5,    0xE5,  // LATIN SMALL LETTER A WITH RING ABOVE
    0xE6,    0xE6,  // LATIN SMALL LETTER AE
    0xE7,    0xE7,  // LATIN SMALL LETTER C WITH CEDILLA
    0xE8,    0xE8,  // LATIN SMALL LETTER E WITH GRAVE
    0xE9,    0xE9,  // LATIN SMALL LETTER E WITH ACUTE
    0xEA,    0xEA,  // LATIN SMALL LETTER E WITH CIRCUMFLEX
    0xEB,    0xEB,  // LATIN SMALL LETTER E WITH DIAERESIS
    0xEC,    0xEC,  // LATIN SMALL LETTER I WITH GRAVE
    0xED,    0xED,  // LATIN SMALL LETTER I WITH ACUTE
    0xEE,    0xEE,  // LATIN SMALL LETTER I WITH CIRCUMFLEX
    0xEF,    0xEF,  // LATIN SMALL LETTER I WITH DIAERESIS
    0xF0,    0xF0,  // LATIN SMALL LETTER ETH
    0xF1,    0xF1,  // LATIN SMALL LETTER N WITH TILDE
    0xF2,    0xF2,  // LATIN SMALL LETTER O WITH GRAVE
    0xF3,    0xF3,  // LATIN SMALL LETTER O WITH ACUTE
    0xF4,    0xF4,  // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0xF5,    0xF5,  // LATIN SMALL LETTER O WITH TILDE
    0xF6,    0xF6,  // LATIN SMALL LETTER O WITH DIAERESIS
    0xF8,    0xF8,  // LATIN SMALL LETTER O WITH STROKE
    0xF9,    0xF9,  // LATIN SMALL LETTER U WITH GRAVE
    0xFA,    0xFA,  // LATIN SMALL LETTER U WITH ACUTE
    0xFB,    0xFB,  // LATIN SMALL LETTER U WITH CIRCUMFLEX
    0xFC,    0xFC,  // LATIN SMALL LETTER U WITH DIAERESIS
    0xFD,    0xFD,  // LATIN SMALL LETTER Y WITH ACUTE
    0xFE,    0xFE,  // LATIN SMALL LETTER THORN
    0xFF,    0xB8,  // LATIN SMALL LETTER Y WITH DIAERESIS
   0x102,    0x80,  // LATIN CAPITAL LETTER A WITH BREVE
   0x103,    0xA0,  // LATIN SMALL LETTER A WITH BREVE
   0x104,    0x81,  // LATIN CAPITAL LETTER A WITH OGONEK
   0x105,    0xA1,  // LATIN SMALL LETTER A WITH OGONEK
   0x106,    0x82,  // LATIN CAPITAL LETTER C WITH ACUTE
   0x107,    0xA2,  // LATIN SMALL LETTER C WITH ACUTE
   0x10C,    0x83,  // LATIN CAPITAL LETTER C WITH CARON
   0x10D,    0xA3,  // LATIN SMALL LETTER C WITH CARON
   0x10E,    0x84,  // LATIN CAPITAL LETTER D WITH CARON
   0x10F,    0xA4,  // LATIN SMALL LETTER D WITH CARON
   0x110,    0xD0,  // LATIN CAPITAL LETTER D WITH STROKE
   0x111,    0x9E,  // LATIN SMALL LETTER D WITH STROKE
   0x118,    0x86,  // LATIN CAPITAL LETTER E WITH OGONEK
   0x119,    0xA6,  // LATIN SMALL LETTER E WITH OGONEK
   0x11A,    0x85,  // LATIN CAPITAL LETTER E WITH CARON
   0x11B,    0xA5,  // LATIN SMALL LETTER E WITH CARON
   0x11E,    0x87,  // LATIN CAPITAL LETTER G WITH BREVE
   0x11F,    0xA7,  // LATIN SMALL LETTER G WITH BREVE
   0x130,    0x9D,  // LATIN CAPITAL LETTER I WITH DOT ABOVE
   0x131,    0x19,  // LATIN SMALL LETTER DOTLESS I
   0x132,    0x9C,  // LATIN CAPITAL LIGATURE IJ
   0x133,    0xBC,  // LATIN SMALL LIGATURE IJ
   0x139,    0x88,  // LATIN CAPITAL LETTER L WITH ACUTE
   0x13A,    0xA8,  // LATIN SMALL LETTER L WITH ACUTE
   0x13D,    0x89,  // LATIN CAPITAL LETTER L WITH CARON
   0x13E,    0xA9,  // LATIN SMALL LETTER L WITH CARON
   0x141,    0x8A,  // LATIN CAPITAL LETTER L WITH STROKE
   0x142,    0xAA,  // LATIN SMALL LETTER L WITH STROKE
   0x143,    0x8B,  // LATIN CAPITAL LETTER N WITH ACUTE
   0x144,    0xAB,  // LATIN SMALL LETTER N WITH ACUTE
   0x147,    0x8C,  // LATIN CAPITAL LETTER N WITH CARON
   0x148,    0xAC,  // LATIN SMALL LETTER N WITH CARON
   0x14A,    0x8D,  // LATIN CAPITAL LETTER ENG
   0x14B,    0xAD,  // LATIN SMALL LETTER ENG
   0x150,    0x8E,  // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
   0x151,    0xAE,  // LATIN SMALL LETTER O WITH DOUBLE ACUTE
   0x152,    0xD7,  // LATIN CAPITAL LIGATURE OE
   0x153,    0xF7,  // LATIN SMALL LIGATURE OE
   0x154,    0x8F,  // LATIN CAPITAL LETTER R WITH ACUTE
   0x155,    0xAF,  // LATIN SMALL LETTER R WITH ACUTE
   0x158,    0x90,  // LATIN CAPITAL LETTER R WITH CARON
   0x159,    0xB0,  // LATIN SMALL LETTER R WITH CARON
   0x15A,    0x91,  // LATIN CAPITAL LETTER S WITH ACUTE
   0x15B,    0xB1,  // LATIN SMALL LETTER S WITH ACUTE
   0x15E,    0x93,  // LATIN CAPITAL LETTER S WITH CEDILLA
   0x15F,    0xB3,  // LATIN SMALL LETTER S WITH CEDILLA
   0x160,    0x92,  // LATIN CAPITAL LETTER S WITH CARON
   0x161,    0xB2,  // LATIN SMALL LETTER S WITH CARON
   0x162,    0x95,  // LATIN CAPITAL LETTER T WITH CEDILLA
   0x163,    0xB5,  // LATIN SMALL LETTER T WITH CEDILLA
   0x164,    0x94,  // LATIN CAPITAL LETTER T WITH CARON
   0x165,    0xB4,  // LATIN SMALL LETTER T WITH CARON
   0x16E,    0x97,  // LATIN CAPITAL LETTER U WITH RING ABOVE
   0x16F,    0xB7,  // LATIN SMALL LETTER U WITH RING ABOVE
   0x170,    0x96,  // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
   0x171,    0xB6,  // LATIN SMALL LETTER U WITH DOUBLE ACUTE
   0x178,    0x98,  // LATIN CAPITAL LETTER Y WITH DIAERESIS
   0x179,    0x99,  // LATIN CAPITAL LETTER Z WITH ACUTE
   0x17A,    0xB9,  // LATIN SMALL LETTER Z WITH ACUTE
   0x17B,    0x9B,  // LATIN CAPITAL LETTER Z WITH DOT ABOVE
   0x17C,    0xBB,  // LATIN SMALL LETTER Z WITH DOT ABOVE
   0x17D,    0x9A,  // LATIN CAPITAL LETTER Z WITH CARON
   0x17E,    0xBA,  // LATIN SMALL LETTER Z WITH CARON
   0x237,    0x1A,  // LATIN SMALL LETTER DOTLESS J
   0x2C6,    0x02,
   0x2C7,    0x07,
   0x2D8,    0x08,
   0x2D9,    0x0A,
   0x2DA,    0x06,
   0x2DB,    0x0C,
   0x2DC,    0x03,
   0x2DD,    0x05,
  0x1E9E,    0xDF,
  0x200C,    0x17,
  0x2010,    0x7F,
  0x2013,    0x15,
  0x2014,    0x16,
  0x2018,    0x60,
  0x2019,    0x27,
  0x201A,    0x0D,
  0x201C,    0x10,
  0x201D,    0x11,
  0x201E,    0x12,
  0x2039,    0x0E,
  0x203A,    0x0F,
  0x2423,    0x20,
};

/* UCS -> TS1 mapping table */
static unsigned short UCStoTS1enc[] = {
    /* from,  to */
    0xA2,    0xA2,
    0xA3,    0xA3,
    0xA4,    0xA4,
    0xA5,    0xA5,
    0xA6,    0xA6,
    0xA7,    0xA7,
    0xA8,    0xA8,
    0xA9,    0xA9,
    0xAA,    0xAA,
    0xAC,    0xAC,
    0xAE,    0xAE,
    0xAF,    0xAF,
    0xB0,    0xB0,
    0xB1,    0xB1,
    0xB2,    0xB2,
    0xB3,    0xB3,
    0xB4,    0xB4,
    0xB5,    0xB5,
    0xB6,    0xB6,
    0xB7,    0xB7,
    0xB8,    0x0B,
    0xB9,    0xB9,
    0xBA,    0xBA,
    0xBC,    0xBC,
    0xBD,    0xBD,
    0xBE,    0xBE,
    0xD7,    0xD6,
    0xF7,    0xF6,
   0x17F,    0x73,  // LATIN SMALL LETTER LONG S
   0x192,    0x8C,  // LATIN SMALL LETTER F WITH HOOK
   0x2C7,    0x81,
   0x2D8,    0x80,
   0x2DB,    0x0C,
   0x2DD,    0x82,
   0x2F7,    0x7E,
   0xE3F,    0x9A,
  0x2016,    0x86,
  0x2020,    0x84,
  0x2021,    0x85,
  0x2022,    0x88,
  0x2030,    0x87,
  0x2031,    0x98,
  0x203B,    0xB8,
  0x203D,    0x94,
  0x2044,    0x2F,
  0x2045,    0xA0,
  0x2046,    0xA1,
  0x204E,    0x2A,
  0x2052,    0x9C,
  0x20A1,    0x8D,
  0x20A4,    0x92,
  0x20A6,    0x8F,
  0x20A9,    0x8E,
  0x20AB,    0x96,
  0x20AC,    0xBF,
  0x20B1,    0x91,
  0x20B2,    0x90,
  0x2103,    0x89,
  0x2116,    0x9B,
  0x2117,    0xAD,
  0x211E,    0x93,
  0x2120,    0x9F,
  0x2122,    0x97,
  0x2126,    0x57,
  0x2127,    0x4D,
  0x212E,    0x9E,
  0x2190,    0x18,
  0x2191,    0x5E,
  0x2192,    0x19,
  0x2193,    0x5F,
  0x2212,    0x3D,
  0x221A,    0xBB,
  0x2329,    0x3C,
  0x232A,    0x3E,
  0x2422,    0x20,
  0x25E6,    0x9E,
  0x25EF,    0x4F,
  0x2605,    0x62,
  0x266A,    0x6E,
  0x26AD,    0x6D,
  0x26AE,    0x63,
  0x271D,    0x64,
  0x27E6,    0x5B,
  0x27E7,    0x5D,
  0x2E17,    0x2D,
  //  0x2E17,    0x7F,
  0x2E18,    0x95,
};

/* UCS -> LY1 mapping table */
static unsigned short UCStoLY1enc[] = {
    /* from,  to */
    0xA0,    0xA0,
    0xA1,    0xA1,
    0xA2,    0xA2,
    0xA3,    0xA3,
    0xA4,    0xA4,
    0xA5,    0xA5,
    0xA6,    0xA6,
    0xA7,    0xA7,
    0xA8,    0x7F,
//    0xA8,    0xA8,
    0xA9,    0xA9,
    0xAA,    0xAA,
    0xAB,    0xAB,
    0xAC,    0xAC,
    0xAD,    0xAD,
    0xAE,    0xAE,
    0xAF,    0x16,
//    0xAF,    0xAF,
    0xB0,    0xB0,
    0xB1,    0xB1,
    0xB2,    0xB2,
    0xB3,    0xB3,
    0xB4,    0x13,
//    0xB4,    0xB4,
    0xB5,    0xB5,
    0xB6,    0xB6,
    0xB7,    0xB7,
    0xB8,    0x18,
//    0xB8,    0xB8,
    0xB9,    0xB9,
    0xBA,    0xBA,
    0xBB,    0xBB,
    0xBC,    0xBC,
    0xBD,    0xBD,
    0xBE,    0xBE,
    0xBF,    0xBF,
    0xC0,    0xC0,  // LATIN CAPITAL LETTER A WITH GRAVE
    0xC1,    0xC1,  // LATIN CAPITAL LETTER A WITH ACUTE
    0xC2,    0xC2,  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0xC3,    0xC3,  // LATIN CAPITAL LETTER A WITH TILDE
    0xC4,    0xC4,  // LATIN CAPITAL LETTER A WITH DIAERESIS
    0xC5,    0xC5,  // LATIN CAPITAL LETTER A WITH RING ABOVE
    0xC6,    0x1D,  // LATIN CAPITAL LETTER AE
//    0xC6,    0xC6,
    0xC7,    0xC7,  // LATIN CAPITAL LETTER C WITH CEDILLA
    0xC8,    0xC8,  // LATIN CAPITAL LETTER E WITH GRAVE
    0xC9,    0xC9,  // LATIN CAPITAL LETTER E WITH ACUTE
    0xCA,    0xCA,  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0xCB,    0xCB,  // LATIN CAPITAL LETTER E WITH DIAERESIS
    0xCC,    0xCC,  // LATIN CAPITAL LETTER I WITH GRAVE
    0xCD,    0xCD,  // LATIN CAPITAL LETTER I WITH ACUTE
    0xCE,    0xCE,  // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0xCF,    0xCF,  // LATIN CAPITAL LETTER I WITH DIAERESIS
    0xD0,    0xD0,  // LATIN CAPITAL LETTER ETH
    0xD1,    0xD1,  // LATIN CAPITAL LETTER N WITH TILDE
    0xD2,    0xD2,  // LATIN CAPITAL LETTER O WITH GRAVE
    0xD3,    0xD3,  // LATIN CAPITAL LETTER O WITH ACUTE
    0xD4,    0xD4,  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0xD5,    0xD5,  // LATIN CAPITAL LETTER O WITH TILDE
    0xD6,    0xD6,  // LATIN CAPITAL LETTER O WITH DIAERESIS
    0xD7,    0xD7,
    0xD8,    0x1F,  // LATIN CAPITAL LETTER O WITH STROKE
//    0xD8,    0xD8,
    0xD9,    0xD9,  // LATIN CAPITAL LETTER U WITH GRAVE
    0xDA,    0xDA,  // LATIN CAPITAL LETTER U WITH ACUTE
    0xDB,    0xDB,  // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0xDC,    0xDC,  // LATIN CAPITAL LETTER U WITH DIAERESIS
    0xDD,    0xDD,  // LATIN CAPITAL LETTER Y WITH ACUTE
    0xDE,    0xDE,  // LATIN CAPITAL LETTER THORN
    0xDF,    0x19,  // LATIN SMALL LETTER SHARP S
//    0xDF,    0xDF,
    0xE0,    0xE0,  // LATIN SMALL LETTER A WITH GRAVE
    0xE1,    0xE1,  // LATIN SMALL LETTER A WITH ACUTE
    0xE2,    0xE2,  // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0xE3,    0xE3,  // LATIN SMALL LETTER A WITH TILDE
    0xE4,    0xE4,  // LATIN SMALL LETTER A WITH DIAERESIS
    0xE5,    0xE5,  // LATIN SMALL LETTER A WITH RING ABOVE
    0xE6,    0x1A,  // LATIN SMALL LETTER AE
//    0xE6,    0xE6,
    0xE7,    0xE7,  // LATIN SMALL LETTER C WITH CEDILLA
    0xE8,    0xE8,  // LATIN SMALL LETTER E WITH GRAVE
    0xE9,    0xE9,  // LATIN SMALL LETTER E WITH ACUTE
    0xEA,    0xEA,  // LATIN SMALL LETTER E WITH CIRCUMFLEX
    0xEB,    0xEB,  // LATIN SMALL LETTER E WITH DIAERESIS
    0xEC,    0xEC,  // LATIN SMALL LETTER I WITH GRAVE
    0xED,    0xED,  // LATIN SMALL LETTER I WITH ACUTE
    0xEE,    0xEE,  // LATIN SMALL LETTER I WITH CIRCUMFLEX
    0xEF,    0xEF,  // LATIN SMALL LETTER I WITH DIAERESIS
    0xF0,    0xF0,  // LATIN SMALL LETTER ETH
    0xF1,    0xF1,  // LATIN SMALL LETTER N WITH TILDE
    0xF2,    0xF2,  // LATIN SMALL LETTER O WITH GRAVE
    0xF3,    0xF3,  // LATIN SMALL LETTER O WITH ACUTE
    0xF4,    0xF4,  // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0xF5,    0xF5,  // LATIN SMALL LETTER O WITH TILDE
    0xF6,    0xF6,  // LATIN SMALL LETTER O WITH DIAERESIS
    0xF7,    0xF7,
    0xF8,    0x1C,  // LATIN SMALL LETTER O WITH STROKE
//    0xF8,    0xF8,
    0xF9,    0xF9,  // LATIN SMALL LETTER U WITH GRAVE
    0xFA,    0xFA,  // LATIN SMALL LETTER U WITH ACUTE
    0xFB,    0xFB,  // LATIN SMALL LETTER U WITH CIRCUMFLEX
    0xFC,    0xFC,  // LATIN SMALL LETTER U WITH DIAERESIS
    0xFD,    0xFD,  // LATIN SMALL LETTER Y WITH ACUTE
    0xFE,    0xFE,  // LATIN SMALL LETTER THORN
    0xFF,    0xFF,  // LATIN SMALL LETTER Y WITH DIAERESIS
   0x131,    0x10,  // LATIN SMALL LETTER DOTLESS I
   0x141,    0x80,  // LATIN CAPITAL LETTER L WITH STROKE
   0x142,    0x90,  // LATIN SMALL LETTER L WITH STROKE
   0x152,    0x1E,  // LATIN CAPITAL LIGATURE OE
//   0x152,    0x8C,
   0x153,    0x1B,  // LATIN SMALL LIGATURE OE
//   0x153,    0x9C,
   0x160,    0x8A,  // LATIN CAPITAL LETTER S WITH CARON
   0x161,    0x9A,  // LATIN SMALL LETTER S WITH CARON
   0x178,    0x9F,  // LATIN CAPITAL LETTER Y WITH DIAERESIS
   0x17D,    0x8D,  // LATIN CAPITAL LETTER Z WITH CARON
   0x17E,    0x9D,  // LATIN SMALL LETTER Z WITH CARON
   0x192,    0x83,  // LATIN SMALL LETTER F WITH HOOK
   0x237,    0x11,  // LATIN SMALL LETTER DOTLESS J
   0x2C6,    0x5E,
//   0x2C6,    0x88,
   0x2C7,    0x14,
   0x2D8,    0x15,
   0x2D9,    0x05,
   0x2DA,    0x17,
   0x2DB,    0x07,
   0x2DC,    0x7E,
//   0x2DC,    0x98,
   0x2DD,    0x06,
  0x200C,    0x0A,
  0x2013,    0x96,
  0x2014,    0x97,
  0x2018,    0x60,
//  0x2018,    0x91,
  0x2019,    0x27,
//  0x2019,    0x92,
  0x201A,    0x82,
  0x201C,    0x93,
  0x201D,    0x94,
  0x201E,    0x84,
  0x2020,    0x86,
  0x2021,    0x87,
  0x2022,    0x95,
  0x2026,    0x85,
  0x2030,    0x89,
  0x2039,    0x8B,
  0x203A,    0x9B,
  0x2044,    0x04,
  0x20AC,    0x01,
  0x2122,    0x99,
  0x2212,    0x8F,
};

/* UCS -> T5 mapping table */
static unsigned short UCStoT5enc[] = {
    /* from,  to */
    0xA8,    0x04,
    0xAB,    0x13,
    0xAF,    0x09,
    0xB4,    0x01,
    0xB8,    0x0B,
    0xBB,    0x14,
    0xC0,    0x80,  // LATIN CAPITAL LETTER A WITH GRAVE
    0xC1,    0x81,  // LATIN CAPITAL LETTER A WITH ACUTE
    0xC2,    0x85,  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0xC3,    0x82,  // LATIN CAPITAL LETTER A WITH TILDE
    0xC8,    0x91,  // LATIN CAPITAL LETTER E WITH GRAVE
    0xC9,    0x92,  // LATIN CAPITAL LETTER E WITH ACUTE
    0xCA,    0x96,  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0xCC,    0x9C,  // LATIN CAPITAL LETTER I WITH GRAVE
    0xCD,    0x9D,  // LATIN CAPITAL LETTER I WITH ACUTE
    0xD2,    0xC1,  // LATIN CAPITAL LETTER O WITH GRAVE
    0xD3,    0xC2,  // LATIN CAPITAL LETTER O WITH ACUTE
    0xD4,    0xC6,  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0xD5,    0xC3,  // LATIN CAPITAL LETTER O WITH TILDE
    0xD9,    0xD2,  // LATIN CAPITAL LETTER U WITH GRAVE
    0xDA,    0xD3,  // LATIN CAPITAL LETTER U WITH ACUTE
    0xDD,    0xDE,  // LATIN CAPITAL LETTER Y WITH ACUTE
    0xE0,    0xA0,  // LATIN SMALL LETTER A WITH GRAVE
    0xE1,    0xA1,  // LATIN SMALL LETTER A WITH ACUTE
    0xE2,    0xA5,  // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0xE3,    0xA2,  // LATIN SMALL LETTER A WITH TILDE
    0xE8,    0xB1,  // LATIN SMALL LETTER E WITH GRAVE
    0xE9,    0xB2,  // LATIN SMALL LETTER E WITH ACUTE
    0xEA,    0xB6,  // LATIN SMALL LETTER E WITH CIRCUMFLEX
    0xEC,    0xBC,  // LATIN SMALL LETTER I WITH GRAVE
    0xED,    0xBD,  // LATIN SMALL LETTER I WITH ACUTE
    0xF2,    0xE1,  // LATIN SMALL LETTER O WITH GRAVE
    0xF3,    0xE2,  // LATIN SMALL LETTER O WITH ACUTE
    0xF4,    0xE6,  // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0xF5,    0xE3,  // LATIN SMALL LETTER O WITH TILDE
    0xF9,    0xF2,  // LATIN SMALL LETTER U WITH GRAVE
    0xFA,    0xF3,  // LATIN SMALL LETTER U WITH ACUTE
    0xFD,    0xFE,  // LATIN SMALL LETTER Y WITH ACUTE
   0x102,    0x8B,  // LATIN CAPITAL LETTER A WITH BREVE
   0x103,    0xAB,  // LATIN SMALL LETTER A WITH BREVE
   0x110,    0x1E,  // LATIN CAPITAL LETTER D WITH STROKE
   0x111,    0x1F,  // LATIN SMALL LETTER D WITH STROKE
   0x128,    0x9E,  // LATIN CAPITAL LETTER I WITH TILDE
   0x129,    0xBE,  // LATIN SMALL LETTER I WITH TILDE
   0x131,    0x19,  // LATIN SMALL LETTER DOTLESS I
   0x168,    0xD4,  // LATIN CAPITAL LETTER U WITH TILDE
   0x169,    0xF4,  // LATIN SMALL LETTER U WITH TILDE
   0x1A0,    0xCC,  // LATIN CAPITAL LETTER O WITH HORN
   0x1A1,    0xEC,  // LATIN SMALL LETTER O WITH HORN
   0x1AF,    0xD7,  // LATIN CAPITAL LETTER U WITH HORN
   0x1B0,    0xF7,  // LATIN SMALL LETTER U WITH HORN
   0x2C6,    0x02,
   0x2C7,    0x07,
   0x2D8,    0x08,
   0x2D9,    0x0A,
   0x2DA,    0x06,
   0x2DC,    0x03,
   0x309,    0x0C,
   0x323,    0x05,
  0x1EA0,    0x84,  // LATIN CAPITAL LETTER A WITH DOT BELOW
  0x1EA1,    0xA4,  // LATIN SMALL LETTER A WITH DOT BELOW
  0x1EA2,    0x83,  // LATIN CAPITAL LETTER A WITH HOOK ABOVE
  0x1EA3,    0xA3,  // LATIN SMALL LETTER A WITH HOOK ABOVE
  0x1EA4,    0x87,  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
  0x1EA5,    0xA7,  // LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
  0x1EA6,    0x86,  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
  0x1EA7,    0xA6,  // LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
  0x1EA8,    0x89,  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
  0x1EA9,    0xA9,  // LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
  0x1EAA,    0x88,  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
  0x1EAB,    0xA8,  // LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
  0x1EAC,    0x8A,  // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
  0x1EAD,    0xAA,  // LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
  0x1EAE,    0x8D,  // LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
  0x1EAF,    0xAD,  // LATIN SMALL LETTER A WITH BREVE AND ACUTE
  0x1EB0,    0x8C,  // LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
  0x1EB1,    0xAC,  // LATIN SMALL LETTER A WITH BREVE AND GRAVE
  0x1EB2,    0x8F,  // LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
  0x1EB3,    0xAF,  // LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
  0x1EB4,    0x8E,  // LATIN CAPITAL LETTER A WITH BREVE AND TILDE
  0x1EB5,    0xAE,  // LATIN SMALL LETTER A WITH BREVE AND TILDE
  0x1EB6,    0x90,  // LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
  0x1EB7,    0xB0,  // LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
  0x1EB8,    0x95,  // LATIN CAPITAL LETTER E WITH DOT BELOW
  0x1EB9,    0xB5,  // LATIN SMALL LETTER E WITH DOT BELOW
  0x1EBA,    0x94,  // LATIN CAPITAL LETTER E WITH HOOK ABOVE
  0x1EBB,    0xB4,  // LATIN SMALL LETTER E WITH HOOK ABOVE
  0x1EBC,    0x93,  // LATIN CAPITAL LETTER E WITH TILDE
  0x1EBD,    0xB3,  // LATIN SMALL LETTER E WITH TILDE
  0x1EBE,    0x98,  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
  0x1EBF,    0xB8,  // LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
  0x1EC0,    0x97,  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
  0x1EC1,    0xB7,  // LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
  0x1EC2,    0x9A,  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
  0x1EC3,    0xBA,  // LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
  0x1EC4,    0x99,  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
  0x1EC5,    0xB9,  // LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
  0x1EC6,    0x9B,  // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
  0x1EC7,    0xBB,  // LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
  0x1EC8,    0x9F,  // LATIN CAPITAL LETTER I WITH HOOK ABOVE
  0x1EC9,    0xBF,  // LATIN SMALL LETTER I WITH HOOK ABOVE
  0x1ECA,    0xC0,  // LATIN CAPITAL LETTER I WITH DOT BELOW
  0x1ECB,    0xE0,  // LATIN SMALL LETTER I WITH DOT BELOW
  0x1ECC,    0xC5,  // LATIN CAPITAL LETTER O WITH DOT BELOW
  0x1ECD,    0xE5,  // LATIN SMALL LETTER O WITH DOT BELOW
  0x1ECE,    0xC4,  // LATIN CAPITAL LETTER O WITH HOOK ABOVE
  0x1ECF,    0xE4,  // LATIN SMALL LETTER O WITH HOOK ABOVE
  0x1ED0,    0xC8,  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
  0x1ED1,    0xE8,  // LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
  0x1ED2,    0xC7,  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
  0x1ED3,    0xE7,  // LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
  0x1ED4,    0xCA,  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
  0x1ED5,    0xEA,  // LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
  0x1ED6,    0xC9,  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
  0x1ED7,    0xE9,  // LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
  0x1ED8,    0xCB,  // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
  0x1ED9,    0xEB,  // LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
  0x1EDA,    0xCE,  // LATIN CAPITAL LETTER O WITH HORN AND ACUTE
  0x1EDB,    0xEE,  // LATIN SMALL LETTER O WITH HORN AND ACUTE
  0x1EDC,    0xCD,  // LATIN CAPITAL LETTER O WITH HORN AND GRAVE
  0x1EDD,    0xED,  // LATIN SMALL LETTER O WITH HORN AND GRAVE
  0x1EDE,    0xD0,  // LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
  0x1EDF,    0xF0,  // LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
  0x1EE0,    0xCF,  // LATIN CAPITAL LETTER O WITH HORN AND TILDE
  0x1EE1,    0xEF,  // LATIN SMALL LETTER O WITH HORN AND TILDE
  0x1EE2,    0xD1,  // LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
  0x1EE3,    0xF1,  // LATIN SMALL LETTER O WITH HORN AND DOT BELOW
  0x1EE4,    0xD6,  // LATIN CAPITAL LETTER U WITH DOT BELOW
  0x1EE5,    0xF6,  // LATIN SMALL LETTER U WITH DOT BELOW
  0x1EE6,    0xD5,  // LATIN CAPITAL LETTER U WITH HOOK ABOVE
  0x1EE7,    0xF5,  // LATIN SMALL LETTER U WITH HOOK ABOVE
  0x1EE8,    0xD9,  // LATIN CAPITAL LETTER U WITH HORN AND ACUTE
  0x1EE9,    0xF9,  // LATIN SMALL LETTER U WITH HORN AND ACUTE
  0x1EEA,    0xD8,  // LATIN CAPITAL LETTER U WITH HORN AND GRAVE
  0x1EEB,    0xF8,  // LATIN SMALL LETTER U WITH HORN AND GRAVE
  0x1EEC,    0xDB,  // LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
  0x1EED,    0xFB,  // LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
  0x1EEE,    0xDA,  // LATIN CAPITAL LETTER U WITH HORN AND TILDE
  0x1EEF,    0xFA,  // LATIN SMALL LETTER U WITH HORN AND TILDE
  0x1EF0,    0xDC,  // LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
  0x1EF1,    0xFC,  // LATIN SMALL LETTER U WITH HORN AND DOT BELOW
  0x1EF2,    0xDD,  // LATIN CAPITAL LETTER Y WITH GRAVE
  0x1EF3,    0xFD,  // LATIN SMALL LETTER Y WITH GRAVE
  0x1EF4,    0x1C,  // LATIN CAPITAL LETTER Y WITH DOT BELOW
  0x1EF5,    0x1D,  // LATIN SMALL LETTER Y WITH DOT BELOW
  0x1EF6,    0x1A,  // LATIN CAPITAL LETTER Y WITH HOOK ABOVE
  0x1EF7,    0x1B,  // LATIN SMALL LETTER Y WITH HOOK ABOVE
  0x1EF8,    0xDF,  // LATIN CAPITAL LETTER Y WITH TILDE
  0x1EF9,    0xFF,  // LATIN SMALL LETTER Y WITH TILDE
  0x200C,    0x17,
  0x2010,    0x7F,
  0x2013,    0x15,
  0x2014,    0x16,
  0x2018,    0x60,
  0x2019,    0x27,
  0x201A,    0x0D,
  0x201C,    0x10,
  0x201D,    0x11,
  0x201E,    0x12,
  0x2039,    0x0E,
  0x203A,    0x0F,
  0x2423,    0x20,
};


/* UCS -> L7X mapping table */
static unsigned short UCStoL7Xenc[] = {
    /* from,  to */
    0xA0,    0xA0,
    0xA2,    0xA2,
    0xA3,    0xA3,
    0xA4,    0xA4,
    0xA6,    0xA6,
    0xA7,    0xA7,
    0xA8,    0x04,
    0xA9,    0xA9,
    0xAB,    0x13,
    0xAC,    0xAC,
    0xAE,    0xAE,
    0xAF,    0x09,
    0xB0,    0xB0,
    0xB1,    0xB1,
    0xB2,    0xB2,
    0xB3,    0xB3,
    0xB4,    0x01,
    0xB5,    0xB5,
    0xB6,    0xB6,
    0xB7,    0xB7,
    0xB8,    0x0B,
    0xB9,    0xB9,
    0xBB,    0x14,
    0xBC,    0xBC,
    0xBD,    0xBD,
    0xBE,    0xBE,
    0xC4,    0xC4,  // LATIN CAPITAL LETTER A WITH DIAERESIS
    0xC5,    0xC5,  // LATIN CAPITAL LETTER A WITH RING ABOVE
    0xC6,    0xAF,  // LATIN CAPITAL LETTER AE
    0xC9,    0xC9,  // LATIN CAPITAL LETTER E WITH ACUTE
    0xD3,    0xD3,  // LATIN CAPITAL LETTER O WITH ACUTE
    0xD5,    0xD5,  // LATIN CAPITAL LETTER O WITH TILDE
    0xD6,    0xD6,  // LATIN CAPITAL LETTER O WITH DIAERESIS
    0xD7,    0xD7,  // MULTIPLICATION SIGN
    0xD8,    0xA8,  // LATIN CAPITAL LETTER O WITH STROKE
    0xDC,    0xDC,  // LATIN CAPITAL LETTER U WITH DIAERESIS
    0xDF,    0xDF,  // LATIN SMALL LETTER SHARP S
    0xE4,    0xE4,  // LATIN SMALL LETTER A WITH DIAERESIS
    0xE5,    0xE5,  // LATIN SMALL LETTER A WITH RING ABOVE
    0xE6,    0xBF,  // LATIN SMALL LETTER AE
    0xE9,    0xE9,  // LATIN SMALL LETTER E WITH ACUTE
    0xF3,    0xF3,  // LATIN SMALL LETTER O WITH ACUTE
    0xF5,    0xF5,  // LATIN SMALL LETTER O WITH TILDE
    0xF6,    0xF6,  // LATIN SMALL LETTER O WITH DIAERESIS
    0xF7,    0xF7,  // DIVISION SIGN
    0xF8,    0xB8,  // LATIN SMALL LETTER O WITH STROKE
    0xFC,    0xFC,  // LATIN SMALL LETTER U WITH DIAERESIS
   0x100,    0xC2,  // LATIN CAPITAL LETTER A WITH MACRON
   0x101,    0xE2,  // LATIN SMALL LETTER A WITH MACRON
   0x104,    0xC0,  // LATIN CAPITAL LETTER A WITH OGONEK
   0x105,    0xE0,  // LATIN SMALL LETTER A WITH OGONEK
   0x106,    0xC3,  // LATIN CAPITAL LETTER C WITH ACUTE
   0x107,    0xE3,  // LATIN SMALL LETTER C WITH ACUTE
   0x10C,    0xC8,  // LATIN CAPITAL LETTER C WITH CARON
   0x10D,    0xE8,  // LATIN SMALL LETTER C WITH CARON
   0x112,    0xC7,  // LATIN CAPITAL LETTER E WITH MACRON
   0x113,    0xE7,  // LATIN SMALL LETTER E WITH MACRON
   0x116,    0xCB,  // LATIN CAPITAL LETTER E WITH DOT ABOVE
   0x117,    0xEB,  // LATIN SMALL LETTER E WITH DOT ABOVE
   0x118,    0xC6,  // LATIN CAPITAL LETTER E WITH OGONEK
   0x119,    0xE6,  // LATIN SMALL LETTER E WITH OGONEK
   0x122,    0xCC,  // LATIN CAPITAL LETTER G WITH CEDILLA
   0x123,    0xEC,  // LATIN SMALL LETTER G WITH CEDILLA
   0x12A,    0xCE,  // LATIN CAPITAL LETTER I WITH MACRON
   0x12B,    0xEE,  // LATIN SMALL LETTER I WITH MACRON
   0x12E,    0xC1,  // LATIN CAPITAL LETTER I WITH OGONEK
   0x12F,    0xE1,  // LATIN SMALL LETTER I WITH OGONEK
   0x131,    0x19,  // LATIN SMALL LETTER DOTLESS I
   0x136,    0xCD,  // LATIN CAPITAL LETTER K WITH CEDILLA
   0x137,    0xED,  // LATIN SMALL LETTER K WITH CEDILLA
   0x13B,    0xCF,  // LATIN CAPITAL LETTER L WITH CEDILLA
   0x13C,    0xEF,  // LATIN SMALL LETTER L WITH CEDILLA
   0x141,    0xD9,  // LATIN CAPITAL LETTER L WITH STROKE
   0x142,    0xF9,  // LATIN SMALL LETTER L WITH STROKE
   0x143,    0xD1,  // LATIN CAPITAL LETTER N WITH ACUTE
   0x144,    0xF1,  // LATIN SMALL LETTER N WITH ACUTE
   0x145,    0xD2,  // LATIN CAPITAL LETTER N WITH CEDILLA
   0x146,    0xF2,  // LATIN SMALL LETTER N WITH CEDILLA
   0x14C,    0xD4,  // LATIN CAPITAL LETTER O WITH MACRON
   0x14D,    0xF4,  // LATIN SMALL LETTER O WITH MACRON
   0x152,    0x8C,  // LATIN CAPITAL LIGATURE OE
   0x153,    0x9C,  // LATIN SMALL LIGATURE OE
   0x156,    0xAA,  // LATIN CAPITAL LETTER R WITH CEDILLA
   0x157,    0xBA,  // LATIN SMALL LETTER R WITH CEDILLA
   0x15A,    0xDA,  // LATIN CAPITAL LETTER S WITH ACUTE
   0x15B,    0xFA,  // LATIN SMALL LETTER S WITH ACUTE
   0x160,    0xD0,  // LATIN CAPITAL LETTER S WITH CARON
   0x161,    0xF0,  // LATIN SMALL LETTER S WITH CARON
   0x16A,    0xDB,  // LATIN CAPITAL LETTER U WITH MACRON
   0x16B,    0xFB,  // LATIN SMALL LETTER U WITH MACRON
   0x172,    0xD8,  // LATIN CAPITAL LETTER U WITH OGONEK
   0x173,    0xF8,  // LATIN SMALL LETTER U WITH OGONEK
   0x179,    0xCA,  // LATIN CAPITAL LETTER Z WITH ACUTE
   0x17A,    0xEA,  // LATIN SMALL LETTER Z WITH ACUTE
   0x17B,    0xDD,  // LATIN CAPITAL LETTER Z WITH DOT ABOVE
   0x17C,    0xFD,  // LATIN SMALL LETTER Z WITH DOT ABOVE
   0x17D,    0xDE,  // LATIN CAPITAL LETTER Z WITH CARON
   0x17E,    0xFE,  // LATIN SMALL LETTER Z WITH CARON
   0x192,    0x83,  // LATIN SMALL LETTER F WITH HOOK
   0x237,    0x1A,  // LATIN SMALL LETTER DOTLESS J
   0x2C6,    0x02,
   0x2C7,    0x07,
   0x2D8,    0x08,
   0x2D9,    0x0A,
   0x2DA,    0x06,
   0x2DB,    0x0C,
   0x2DC,    0x03,
   0x2DD,    0x05,
  0x200C,    0x17,
  0x2010,    0xAD,
  0x2013,    0x15,
  0x2014,    0x16,
  0x2018,    0x60,
  0x2019,    0x27,
  0x201A,    0x0D,
  0x201C,    0x10,
  0x201D,    0x11,
  0x201E,    0x12,
  0x2020,    0x86,
  0x2021,    0x87,
  0x2022,    0x95,
  0x2026,    0x85,
  0x2030,    0x89,
  0x2039,    0x0E,
  0x203A,    0x0F,
  0x20AC,    0x80,
  0x2122,    0x99,
};

/* UCS -> T2A mapping table */
static unsigned short UCStoT2Aenc[] = {
    /* from,  to */
    0x49,    0x49,  // Latin Capital Letter I; glyph for \CYRII, U+0406 І
    0x4A,    0x4A,  // Latin Capital Letter J; glyph for \CYRJE, U+0408 Ј
    0x51,    0x51,  // Latin Capital Letter Q; glyph for \CYRQ,  U+051A Ԛ
    0x57,    0x57,  // Latin Capital Letter W; glyph for \CYRW,  U+051C Ԝ
    0x69,    0x69,  // Latin Small Letter I;   glyph for \cyrii, U+0456 і
    0x6A,    0x6A,  // Latin Small Letter J;   glyph for \cyrje, U+0458 ј
    0x71,    0x71,  // Latin Small Letter Q;   glyph for \cyrq,  U+051B ԛ
    0x77,    0x77,  // Latin Small Letter W;   glyph for \cyrw,  U+051D ԝ
    0xA4,    0x9E,
    0xA7,    0x9F,
    0xA8,    0x04,
    0xAB,    0xBE,
    0xAF,    0x09,
    0xB4,    0x01,
    0xB8,    0x0B,
    0xBB,    0xBF,
   0x131,    0x19,  // LATIN SMALL LETTER DOTLESS I
   0x237,    0x1A,  // LATIN SMALL LETTER DOTLESS J
   0x2C6,    0x02,
   0x2C7,    0x07,
   0x2D8,    0x08,
   0x2D9,    0x0A,
   0x2DA,    0x06,
   0x2DB,    0x0C,
   0x2DC,    0x03,
   0x2DD,    0x05,
   0x401,    0x9C,  // CYRILLIC CAPITAL LETTER IO
   0x402,    0x82,  // CYRILLIC CAPITAL LETTER DJE
   0x404,    0x99,  // CYRILLIC CAPITAL LETTER UKRAINIAN IE
   0x405,    0x8F,  // CYRILLIC CAPITAL LETTER DZE
   0x406,    0x49,  // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I; \CYRII
   0x407,    0x88,  // CYRILLIC CAPITAL LETTER YI
   0x408,    0x4A,  // CYRILLIC CAPITAL LETTER JE                      ; \CYRJE
   0x409,    0x87,  // CYRILLIC CAPITAL LETTER LJE
   0x40A,    0x9B,  // CYRILLIC CAPITAL LETTER NJE
   0x40B,    0x83,  // CYRILLIC CAPITAL LETTER TSHE
   0x40E,    0x92,  // CYRILLIC CAPITAL LETTER SHORT U
   0x40F,    0x96,  // CYRILLIC CAPITAL LETTER DZHE
   0x410,    0xC0,  // CYRILLIC CAPITAL LETTER A
   0x411,    0xC1,  // CYRILLIC CAPITAL LETTER BE
   0x412,    0xC2,  // CYRILLIC CAPITAL LETTER VE
   0x413,    0xC3,  // CYRILLIC CAPITAL LETTER GHE
   0x414,    0xC4,  // CYRILLIC CAPITAL LETTER DE
   0x415,    0xC5,  // CYRILLIC CAPITAL LETTER IE
   0x416,    0xC6,  // CYRILLIC CAPITAL LETTER ZHE
   0x417,    0xC7,  // CYRILLIC CAPITAL LETTER ZE
   0x418,    0xC8,  // CYRILLIC CAPITAL LETTER I
   0x419,    0xC9,  // CYRILLIC CAPITAL LETTER SHORT I
   0x41A,    0xCA,  // CYRILLIC CAPITAL LETTER KA
   0x41B,    0xCB,  // CYRILLIC CAPITAL LETTER EL
   0x41C,    0xCC,  // CYRILLIC CAPITAL LETTER EM
   0x41D,    0xCD,  // CYRILLIC CAPITAL LETTER EN
   0x41E,    0xCE,  // CYRILLIC CAPITAL LETTER O
   0x41F,    0xCF,  // CYRILLIC CAPITAL LETTER PE
   0x420,    0xD0,  // CYRILLIC CAPITAL LETTER ER
   0x421,    0xD1,  // CYRILLIC CAPITAL LETTER ES
   0x422,    0xD2,  // CYRILLIC CAPITAL LETTER TE
   0x423,    0xD3,  // CYRILLIC CAPITAL LETTER U
   0x424,    0xD4,  // CYRILLIC CAPITAL LETTER EF
   0x425,    0xD5,  // CYRILLIC CAPITAL LETTER HA
   0x426,    0xD6,  // CYRILLIC CAPITAL LETTER TSE
   0x427,    0xD7,  // CYRILLIC CAPITAL LETTER CHE
   0x428,    0xD8,  // CYRILLIC CAPITAL LETTER SHA
   0x429,    0xD9,  // CYRILLIC CAPITAL LETTER SHCHA
   0x42A,    0xDA,  // CYRILLIC CAPITAL LETTER HARD SIGN
   0x42B,    0xDB,  // CYRILLIC CAPITAL LETTER YERU
   0x42C,    0xDC,  // CYRILLIC CAPITAL LETTER SOFT SIGN
   0x42D,    0xDD,  // CYRILLIC CAPITAL LETTER E
   0x42E,    0xDE,  // CYRILLIC CAPITAL LETTER YU
   0x42F,    0xDF,  // CYRILLIC CAPITAL LETTER YA
   0x430,    0xE0,  // CYRILLIC SMALL LETTER A
   0x431,    0xE1,  // CYRILLIC SMALL LETTER BE
   0x432,    0xE2,  // CYRILLIC SMALL LETTER VE
   0x433,    0xE3,  // CYRILLIC SMALL LETTER GHE
   0x434,    0xE4,  // CYRILLIC SMALL LETTER DE
   0x435,    0xE5,  // CYRILLIC SMALL LETTER IE
   0x436,    0xE6,  // CYRILLIC SMALL LETTER ZHE
   0x437,    0xE7,  // CYRILLIC SMALL LETTER ZE
   0x438,    0xE8,  // CYRILLIC SMALL LETTER I
   0x439,    0xE9,  // CYRILLIC SMALL LETTER SHORT I
   0x43A,    0xEA,  // CYRILLIC SMALL LETTER KA
   0x43B,    0xEB,  // CYRILLIC SMALL LETTER EL
   0x43C,    0xEC,  // CYRILLIC SMALL LETTER EM
   0x43D,    0xED,  // CYRILLIC SMALL LETTER EN
   0x43E,    0xEE,  // CYRILLIC SMALL LETTER O
   0x43F,    0xEF,  // CYRILLIC SMALL LETTER PE
   0x440,    0xF0,  // CYRILLIC SMALL LETTER ER
   0x441,    0xF1,  // CYRILLIC SMALL LETTER ES
   0x442,    0xF2,  // CYRILLIC SMALL LETTER TE
   0x443,    0xF3,  // CYRILLIC SMALL LETTER U
   0x444,    0xF4,  // CYRILLIC SMALL LETTER EF
   0x445,    0xF5,  // CYRILLIC SMALL LETTER HA
   0x446,    0xF6,  // CYRILLIC SMALL LETTER TSE
   0x447,    0xF7,  // CYRILLIC SMALL LETTER CHE
   0x448,    0xF8,  // CYRILLIC SMALL LETTER SHA
   0x449,    0xF9,  // CYRILLIC SMALL LETTER SHCHA
   0x44A,    0xFA,  // CYRILLIC SMALL LETTER HARD SIGN
   0x44B,    0xFB,  // CYRILLIC SMALL LETTER YERU
   0x44C,    0xFC,  // CYRILLIC SMALL LETTER SOFT SIGN
   0x44D,    0xFD,  // CYRILLIC SMALL LETTER E
   0x44E,    0xFE,  // CYRILLIC SMALL LETTER YU
   0x44F,    0xFF,  // CYRILLIC SMALL LETTER YA
   0x451,    0xBC,  // CYRILLIC SMALL LETTER IO
   0x452,    0xA2,  // CYRILLIC SMALL LETTER DJE
   0x454,    0xB9,  // CYRILLIC SMALL LETTER UKRAINIAN IE
   0x455,    0xAF,  // CYRILLIC SMALL LETTER DZE
   0x456,    0x69,  // CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I;   \cyrii
   0x457,    0xA8,  // CYRILLIC SMALL LETTER YI
   0x458,    0x6A,  // CYRILLIC SMALL LETTER JE;                         \cyrje
   0x459,    0xA7,  // CYRILLIC SMALL LETTER LJE
   0x45A,    0xBB,  // CYRILLIC SMALL LETTER NJE
   0x45B,    0xA3,  // CYRILLIC SMALL LETTER TSHE
   0x45E,    0xB2,  // CYRILLIC SMALL LETTER SHORT U
   0x45F,    0xB6,  // CYRILLIC SMALL LETTER DZHE
   0x490,    0x80,  // CYRILLIC CAPITAL LETTER GHE WITH UPTURN
   0x491,    0xA0,  // CYRILLIC SMALL LETTER GHE WITH UPTURN
   0x492,    0x81,  // CYRILLIC CAPITAL LETTER GHE WITH STROKE
   0x493,    0xA1,  // CYRILLIC SMALL LETTER GHE WITH STROKE
   0x496,    0x85,  // CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
   0x497,    0xA5,  // CYRILLIC SMALL LETTER ZHE WITH DESCENDER
   0x498,    0x86,  // CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
   0x499,    0xA6,  // CYRILLIC SMALL LETTER ZE WITH DESCENDER
   0x49A,    0x89,  // CYRILLIC CAPITAL LETTER KA WITH DESCENDER
   0x49B,    0xA9,  // CYRILLIC SMALL LETTER KA WITH DESCENDER
   0x49C,    0x8B,  // CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
   0x49D,    0xAB,  // CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
   0x4A0,    0x8A,  // CYRILLIC CAPITAL LETTER BASHKIR KA
   0x4A1,    0xAA,  // CYRILLIC SMALL LETTER BASHKIR KA
   0x4A2,    0x8D,  // CYRILLIC CAPITAL LETTER EN WITH DESCENDER
   0x4A3,    0xAD,  // CYRILLIC SMALL LETTER EN WITH DESCENDER
   0x4A4,    0x8E,  // CYRILLIC CAPITAL LIGATURE EN GHE
   0x4A5,    0xAE,  // CYRILLIC SMALL LIGATURE EN GHE
   0x4AA,    0x91,  // CYRILLIC CAPITAL LETTER ES WITH DESCENDER
   0x4AB,    0xB1,  // CYRILLIC SMALL LETTER ES WITH DESCENDER
   0x4AE,    0x93,  // CYRILLIC CAPITAL LETTER STRAIGHT U
   0x4AF,    0xB3,  // CYRILLIC SMALL LETTER STRAIGHT U
   0x4B0,    0x94,  // CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
   0x4B1,    0xB4,  // CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
   0x4B2,    0x95,  // CYRILLIC CAPITAL LETTER HA WITH DESCENDER
   0x4B3,    0xB5,  // CYRILLIC SMALL LETTER HA WITH DESCENDER
   0x4B6,    0x98,  // CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
   0x4B7,    0xB8,  // CYRILLIC SMALL LETTER CHE WITH DESCENDER
   0x4B8,    0x97,  // CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
   0x4B9,    0xB7,  // CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
   0x4BA,    0x84,  // CYRILLIC CAPITAL LETTER SHHA
   0x4BB,    0xA4,  // CYRILLIC SMALL LETTER SHHA
   0x4C0,    0x0D,  // CYRILLIC LETTER PALOCHKA
   0x4D4,    0x8C,  // CYRILLIC CAPITAL LIGATURE A IE
   0x4D5,    0xAC,  // CYRILLIC SMALL LIGATURE A IE
   0x4D8,    0x9A,  // CYRILLIC CAPITAL LETTER SCHWA
   0x4D9,    0xBA,  // CYRILLIC SMALL LETTER SCHWA
   0x4E8,    0x90,  // CYRILLIC CAPITAL LETTER BARRED O
   0x4E9,    0xB0,  // CYRILLIC SMALL LETTER BARRED O
   0x51A,    0x51,  // CYRILLIC CAPITAL LETTER QA;   \CYRQ
   0x51B,    0x71,  // CYRILLIC SMALL LETTER QA;     \cyrq
   0x51C,    0x57,  // CYRILLIC CAPITAL LETTER WE;   \CYRW
   0x51D,    0x77,  // CYRILLIC SMALL LETTER WE;     \cyrw
  0x200C,    0x17,
  0x2010,    0x7F,
  0x2013,    0x15,
  0x2014,    0x16,
  0x2018,    0x60,
  0x2019,    0x27,
  0x201C,    0x10,
  0x201D,    0x11,
  0x201E,    0xBD,
  0x2116,    0x9D,
  0x2329,    0x0E,
  0x232A,    0x0F,
  0x2423,    0x20,
};

/* UCS -> T2B mapping table */
static unsigned short UCStoT2Benc[] = {
    /* from,  to */
    0x49,    0x49,  // Latin Capital Letter I; glyph for \CYRII, U+0406 І
    0x4A,    0x4A,  // Latin Capital Letter J; glyph for \CYRJE, U+0408 Ј
    0x51,    0x51,  // Latin Capital Letter Q; glyph for \CYRQ,  U+051A Ԛ
    0x57,    0x57,  // Latin Capital Letter W; glyph for \CYRW,  U+051C Ԝ
    0x69,    0x69,  // Latin Small Letter I;   glyph for \cyrii, U+0456 і
    0x6A,    0x6A,  // Latin Small Letter J;   glyph for \cyrje, U+0458 ј
    0x71,    0x71,  // Latin Small Letter Q;   glyph for \cyrq,  U+051B ԛ
    0x77,    0x77,  // Latin Small Letter W;   glyph for \cyrw,  U+051D ԝ
    0xA4,    0x9E,
    0xA7,    0x9F,
    0xA8,    0x04,
    0xAB,    0xBE,
    0xAF,    0x09,
    0xB4,    0x01,
    0xB8,    0x0B,
    0xBB,    0xBF,
   0x131,    0x19,  // LATIN SMALL LETTER DOTLESS I
   0x237,    0x1A,  // LATIN SMALL LETTER DOTLESS J
   0x2C6,    0x02,
   0x2C7,    0x07,
   0x2D8,    0x08,
   0x2D9,    0x0A,
   0x2DA,    0x06,
   0x2DB,    0x0C,
   0x2DC,    0x03,
   0x2DD,    0x05,
   0x401,    0x9C,  // CYRILLIC CAPITAL LETTER IO
   0x406,    0x49,  // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I; \CYRII
   0x408,    0x4A,  // CYRILLIC CAPITAL LETTER JE                      ; \CYRJE
   0x409,    0x88,  // CYRILLIC CAPITAL LETTER LJE
   0x40A,    0x99,  // CYRILLIC CAPITAL LETTER NJE
   0x40E,    0x92,  // CYRILLIC CAPITAL LETTER SHORT U
   0x410,    0xC0,  // CYRILLIC CAPITAL LETTER A
   0x411,    0xC1,  // CYRILLIC CAPITAL LETTER BE
   0x412,    0xC2,  // CYRILLIC CAPITAL LETTER VE
   0x413,    0xC3,  // CYRILLIC CAPITAL LETTER GHE
   0x414,    0xC4,  // CYRILLIC CAPITAL LETTER DE
   0x415,    0xC5,  // CYRILLIC CAPITAL LETTER IE
   0x416,    0xC6,  // CYRILLIC CAPITAL LETTER ZHE
   0x417,    0xC7,  // CYRILLIC CAPITAL LETTER ZE
   0x418,    0xC8,  // CYRILLIC CAPITAL LETTER I
   0x419,    0xC9,  // CYRILLIC CAPITAL LETTER SHORT I
   0x41A,    0xCA,  // CYRILLIC CAPITAL LETTER KA
   0x41B,    0xCB,  // CYRILLIC CAPITAL LETTER EL
   0x41C,    0xCC,  // CYRILLIC CAPITAL LETTER EM
   0x41D,    0xCD,  // CYRILLIC CAPITAL LETTER EN
   0x41E,    0xCE,  // CYRILLIC CAPITAL LETTER O
   0x41F,    0xCF,  // CYRILLIC CAPITAL LETTER PE
   0x420,    0xD0,  // CYRILLIC CAPITAL LETTER ER
   0x421,    0xD1,  // CYRILLIC CAPITAL LETTER ES
   0x422,    0xD2,  // CYRILLIC CAPITAL LETTER TE
   0x423,    0xD3,  // CYRILLIC CAPITAL LETTER U
   0x424,    0xD4,  // CYRILLIC CAPITAL LETTER EF
   0x425,    0xD5,  // CYRILLIC CAPITAL LETTER HA
   0x426,    0xD6,  // CYRILLIC CAPITAL LETTER TSE
   0x427,    0xD7,  // CYRILLIC CAPITAL LETTER CHE
   0x428,    0xD8,  // CYRILLIC CAPITAL LETTER SHA
   0x429,    0xD9,  // CYRILLIC CAPITAL LETTER SHCHA
   0x42A,    0xDA,  // CYRILLIC CAPITAL LETTER HARD SIGN
   0x42B,    0xDB,  // CYRILLIC CAPITAL LETTER YERU
   0x42C,    0xDC,  // CYRILLIC CAPITAL LETTER SOFT SIGN
   0x42D,    0xDD,  // CYRILLIC CAPITAL LETTER E
   0x42E,    0xDE,  // CYRILLIC CAPITAL LETTER YU
   0x42F,    0xDF,  // CYRILLIC CAPITAL LETTER YA
   0x430,    0xE0,  // CYRILLIC SMALL LETTER A
   0x431,    0xE1,  // CYRILLIC SMALL LETTER BE
   0x432,    0xE2,  // CYRILLIC SMALL LETTER VE
   0x433,    0xE3,  // CYRILLIC SMALL LETTER GHE
   0x434,    0xE4,  // CYRILLIC SMALL LETTER DE
   0x435,    0xE5,  // CYRILLIC SMALL LETTER IE
   0x436,    0xE6,  // CYRILLIC SMALL LETTER ZHE
   0x437,    0xE7,  // CYRILLIC SMALL LETTER ZE
   0x438,    0xE8,  // CYRILLIC SMALL LETTER I
   0x439,    0xE9,  // CYRILLIC SMALL LETTER SHORT I
   0x43A,    0xEA,  // CYRILLIC SMALL LETTER KA
   0x43B,    0xEB,  // CYRILLIC SMALL LETTER EL
   0x43C,    0xEC,  // CYRILLIC SMALL LETTER EM
   0x43D,    0xED,  // CYRILLIC SMALL LETTER EN
   0x43E,    0xEE,  // CYRILLIC SMALL LETTER O
   0x43F,    0xEF,  // CYRILLIC SMALL LETTER PE
   0x440,    0xF0,  // CYRILLIC SMALL LETTER ER
   0x441,    0xF1,  // CYRILLIC SMALL LETTER ES
   0x442,    0xF2,  // CYRILLIC SMALL LETTER TE
   0x443,    0xF3,  // CYRILLIC SMALL LETTER U
   0x444,    0xF4,  // CYRILLIC SMALL LETTER EF
   0x445,    0xF5,  // CYRILLIC SMALL LETTER HA
   0x446,    0xF6,  // CYRILLIC SMALL LETTER TSE
   0x447,    0xF7,  // CYRILLIC SMALL LETTER CHE
   0x448,    0xF8,  // CYRILLIC SMALL LETTER SHA
   0x449,    0xF9,  // CYRILLIC SMALL LETTER SHCHA
   0x44A,    0xFA,  // CYRILLIC SMALL LETTER HARD SIGN
   0x44B,    0xFB,  // CYRILLIC SMALL LETTER YERU
   0x44C,    0xFC,  // CYRILLIC SMALL LETTER SOFT SIGN
   0x44D,    0xFD,  // CYRILLIC SMALL LETTER E
   0x44E,    0xFE,  // CYRILLIC SMALL LETTER YU
   0x44F,    0xFF,  // CYRILLIC SMALL LETTER YA
   0x451,    0xBC,  // CYRILLIC SMALL LETTER IO
   0x456,    0x69,  // CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I;   \cyrii
   0x458,    0x6A,  // CYRILLIC SMALL LETTER JE;                         \cyrje
   0x459,    0xA8,  // CYRILLIC SMALL LETTER LJE
   0x45A,    0xB9,  // CYRILLIC SMALL LETTER NJE
   0x45E,    0xB2,  // CYRILLIC SMALL LETTER SHORT U
   0x492,    0x81,  // CYRILLIC CAPITAL LETTER GHE WITH STROKE
   0x493,    0xA1,  // CYRILLIC SMALL LETTER GHE WITH STROKE
   0x494,    0x83,  // CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
   0x495,    0xA3,  // CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
   0x496,    0x85,  // CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
   0x497,    0xA5,  // CYRILLIC SMALL LETTER ZHE WITH DESCENDER
   0x49A,    0x89,  // CYRILLIC CAPITAL LETTER KA WITH DESCENDER
   0x49B,    0xA9,  // CYRILLIC SMALL LETTER KA WITH DESCENDER
   0x4A2,    0x8D,  // CYRILLIC CAPITAL LETTER EN WITH DESCENDER
   0x4A3,    0xAD,  // CYRILLIC SMALL LETTER EN WITH DESCENDER
   0x4A4,    0x8E,  // CYRILLIC CAPITAL LIGATURE EN GHE
   0x4A5,    0xAE,  // CYRILLIC SMALL LIGATURE EN GHE
   0x4AE,    0x93,  // CYRILLIC CAPITAL LETTER STRAIGHT U
   0x4AF,    0xB3,  // CYRILLIC SMALL LETTER STRAIGHT U
   0x4B2,    0x95,  // CYRILLIC CAPITAL LETTER HA WITH DESCENDER
   0x4B3,    0xB5,  // CYRILLIC SMALL LETTER HA WITH DESCENDER
   0x4B6,    0x98,  // CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
   0x4B7,    0xB8,  // CYRILLIC SMALL LETTER CHE WITH DESCENDER
   0x4BA,    0x84,  // CYRILLIC CAPITAL LETTER SHHA
   0x4BB,    0xA4,  // CYRILLIC SMALL LETTER SHHA
   0x4C0,    0x0D,  // CYRILLIC LETTER PALOCHKA
   0x4C3,    0x8B,  // CYRILLIC CAPITAL LETTER KA WITH HOOK
   0x4C4,    0xAB,  // CYRILLIC SMALL LETTER KA WITH HOOK
   0x4C5,    0x8A,  // CYRILLIC CAPITAL LETTER EL WITH TAIL
   0x4C6,    0xAA,  // CYRILLIC SMALL LETTER EL WITH TAIL
   0x4C7,    0x8F,  // CYRILLIC CAPITAL LETTER EN WITH HOOK
   0x4C8,    0xAF,  // CYRILLIC SMALL LETTER EN WITH HOOK
   0x4CB,    0x97,  // CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
   0x4CC,    0xB7,  // CYRILLIC SMALL LETTER KHAKASSIAN CHE
   0x4D8,    0x9A,  // CYRILLIC CAPITAL LETTER SCHWA
   0x4D9,    0xBA,  // CYRILLIC SMALL LETTER SCHWA
   0x4E0,    0x87,  // CYRILLIC CAPITAL LETTER ABKHASIAN DZE
   0x4E1,    0xA7,  // CYRILLIC SMALL LETTER ABKHASIAN DZE
   0x4E8,    0x90,  // CYRILLIC CAPITAL LETTER BARRED O
   0x4E9,    0xB0,  // CYRILLIC SMALL LETTER BARRED O
   0x4F6,    0x82,  // CYRILLIC CAPITAL LETTER GHE WITH DESCENDER
   0x4F7,    0xA2,  // CYRILLIC SMALL LETTER GHE WITH DESCENDER
   0x4FA,    0x80,  // CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK
   0x4FB,    0xA0,  // CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK
   0x4FC,    0x96,  // CYRILLIC CAPITAL LETTER HA WITH HOOK
   0x4FD,    0xB6,  // CYRILLIC SMALL LETTER HA WITH HOOK
   0x4FE,    0x94,  // CYRILLIC CAPITAL LETTER HA WITH STROKE
   0x4FF,    0xB4,  // CYRILLIC SMALL LETTER HA WITH STROKE
   0x510,    0x9B,  // CYRILLIC CAPITAL LETTER REVERSED ZE
   0x511,    0xBB,  // CYRILLIC SMALL LETTER REVERSED ZE
   0x512,    0x8C,  // CYRILLIC CAPITAL LETTER EL WITH HOOK
   0x513,    0xAC,  // CYRILLIC SMALL LETTER EL WITH HOOK
   0x51A,    0x51,  // CYRILLIC CAPITAL LETTER QA;   \CYRQ
   0x51B,    0x71,  // CYRILLIC SMALL LETTER QA;     \cyrq
   0x51C,    0x57,  // CYRILLIC CAPITAL LETTER WE;   \CYRW
   0x51D,    0x77,  // CYRILLIC SMALL LETTER WE;     \cyrw
  0x200C,    0x17,
  0x2010,    0x7F,
  0x2013,    0x15,
  0x2014,    0x16,
  0x2018,    0x60,
  0x2019,    0x27,
  0x201C,    0x10,
  0x201D,    0x11,
  0x201E,    0xBD,
  0x2116,    0x9D,
  0x2329,    0x0E,
  0x232A,    0x0F,
  0x2423,    0x20,
};

/* UCS -> T2C mapping table */
static unsigned short UCStoT2Cenc[] = {
    /* from,  to */
    0x49,    0x49,  // Latin Capital Letter I; glyph for \CYRII, U+0406 І
    0x4A,    0x4A,  // Latin Capital Letter J; glyph for \CYRJE, U+0408 Ј
    0x51,    0x51,  // Latin Capital Letter Q; glyph for \CYRQ,  U+051A Ԛ
    0x57,    0x57,  // Latin Capital Letter W; glyph for \CYRW,  U+051C Ԝ
    0x69,    0x69,  // Latin Small Letter I;   glyph for \cyrii, U+0456 і
    0x6A,    0x6A,  // Latin Small Letter J;   glyph for \cyrje, U+0458 ј
    0x71,    0x71,  // Latin Small Letter Q;   glyph for \cyrq,  U+051B ԛ
    0x77,    0x77,  // Latin Small Letter W;   glyph for \cyrw,  U+051D ԝ
    0xA4,    0x9E,
    0xA7,    0x9F,
    0xA8,    0x04,
    0xAB,    0xBE,
    0xAF,    0x09,
    0xB4,    0x01,
    0xB8,    0x0B,
    0xBB,    0xBF,
   0x131,    0x19,  // LATIN SMALL LETTER DOTLESS I
   0x237,    0x1A,  // LATIN SMALL LETTER DOTLESS J
   0x2C6,    0x02,
   0x2C7,    0x07,
   0x2D8,    0x08,
   0x2D9,    0x0A,
   0x2DA,    0x06,
   0x2DB,    0x0C,
   0x2DC,    0x03,
   0x2DD,    0x05,
   0x401,    0x9C,  // CYRILLIC CAPITAL LETTER IO
   0x406,    0x49,  // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I; \CYRII
   0x408,    0x4A,  // CYRILLIC CAPITAL LETTER JE                      ; \CYRJE
   0x40F,    0x96,  // CYRILLIC CAPITAL LETTER DZHE
   0x410,    0xC0,  // CYRILLIC CAPITAL LETTER A
   0x411,    0xC1,  // CYRILLIC CAPITAL LETTER BE
   0x412,    0xC2,  // CYRILLIC CAPITAL LETTER VE
   0x413,    0xC3,  // CYRILLIC CAPITAL LETTER GHE
   0x414,    0xC4,  // CYRILLIC CAPITAL LETTER DE
   0x415,    0xC5,  // CYRILLIC CAPITAL LETTER IE
   0x416,    0xC6,  // CYRILLIC CAPITAL LETTER ZHE
   0x417,    0xC7,  // CYRILLIC CAPITAL LETTER ZE
   0x418,    0xC8,  // CYRILLIC CAPITAL LETTER I
   0x419,    0xC9,  // CYRILLIC CAPITAL LETTER SHORT I
   0x41A,    0xCA,  // CYRILLIC CAPITAL LETTER KA
   0x41B,    0xCB,  // CYRILLIC CAPITAL LETTER EL
   0x41C,    0xCC,  // CYRILLIC CAPITAL LETTER EM
   0x41D,    0xCD,  // CYRILLIC CAPITAL LETTER EN
   0x41E,    0xCE,  // CYRILLIC CAPITAL LETTER O
   0x41F,    0xCF,  // CYRILLIC CAPITAL LETTER PE
   0x420,    0xD0,  // CYRILLIC CAPITAL LETTER ER
   0x421,    0xD1,  // CYRILLIC CAPITAL LETTER ES
   0x422,    0xD2,  // CYRILLIC CAPITAL LETTER TE
   0x423,    0xD3,  // CYRILLIC CAPITAL LETTER U
   0x424,    0xD4,  // CYRILLIC CAPITAL LETTER EF
   0x425,    0xD5,  // CYRILLIC CAPITAL LETTER HA
   0x426,    0xD6,  // CYRILLIC CAPITAL LETTER TSE
   0x427,    0xD7,  // CYRILLIC CAPITAL LETTER CHE
   0x428,    0xD8,  // CYRILLIC CAPITAL LETTER SHA
   0x429,    0xD9,  // CYRILLIC CAPITAL LETTER SHCHA
   0x42A,    0xDA,  // CYRILLIC CAPITAL LETTER HARD SIGN
   0x42B,    0xDB,  // CYRILLIC CAPITAL LETTER YERU
   0x42C,    0xDC,  // CYRILLIC CAPITAL LETTER SOFT SIGN
   0x42D,    0xDD,  // CYRILLIC CAPITAL LETTER E
   0x42E,    0xDE,  // CYRILLIC CAPITAL LETTER YU
   0x42F,    0xDF,  // CYRILLIC CAPITAL LETTER YA
   0x430,    0xE0,  // CYRILLIC SMALL LETTER A
   0x431,    0xE1,  // CYRILLIC SMALL LETTER BE
   0x432,    0xE2,  // CYRILLIC SMALL LETTER VE
   0x433,    0xE3,  // CYRILLIC SMALL LETTER GHE
   0x434,    0xE4,  // CYRILLIC SMALL LETTER DE
   0x435,    0xE5,  // CYRILLIC SMALL LETTER IE
   0x436,    0xE6,  // CYRILLIC SMALL LETTER ZHE
   0x437,    0xE7,  // CYRILLIC SMALL LETTER ZE
   0x438,    0xE8,  // CYRILLIC SMALL LETTER I
   0x439,    0xE9,  // CYRILLIC SMALL LETTER SHORT I
   0x43A,    0xEA,  // CYRILLIC SMALL LETTER KA
   0x43B,    0xEB,  // CYRILLIC SMALL LETTER EL
   0x43C,    0xEC,  // CYRILLIC SMALL LETTER EM
   0x43D,    0xED,  // CYRILLIC SMALL LETTER EN
   0x43E,    0xEE,  // CYRILLIC SMALL LETTER O
   0x43F,    0xEF,  // CYRILLIC SMALL LETTER PE
   0x440,    0xF0,  // CYRILLIC SMALL LETTER ER
   0x441,    0xF1,  // CYRILLIC SMALL LETTER ES
   0x442,    0xF2,  // CYRILLIC SMALL LETTER TE
   0x443,    0xF3,  // CYRILLIC SMALL LETTER U
   0x444,    0xF4,  // CYRILLIC SMALL LETTER EF
   0x445,    0xF5,  // CYRILLIC SMALL LETTER HA
   0x446,    0xF6,  // CYRILLIC SMALL LETTER TSE
   0x447,    0xF7,  // CYRILLIC SMALL LETTER CHE
   0x448,    0xF8,  // CYRILLIC SMALL LETTER SHA
   0x449,    0xF9,  // CYRILLIC SMALL LETTER SHCHA
   0x44A,    0xFA,  // CYRILLIC SMALL LETTER HARD SIGN
   0x44B,    0xFB,  // CYRILLIC SMALL LETTER YERU
   0x44C,    0xFC,  // CYRILLIC SMALL LETTER SOFT SIGN
   0x44D,    0xFD,  // CYRILLIC SMALL LETTER E
   0x44E,    0xFE,  // CYRILLIC SMALL LETTER YU
   0x44F,    0xFF,  // CYRILLIC SMALL LETTER YA
   0x451,    0xBC,  // CYRILLIC SMALL LETTER IO
   0x456,    0x69,  // CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I;   \cyrii
   0x458,    0x6A,  // CYRILLIC SMALL LETTER JE;                         \cyrje
   0x45F,    0xB6,  // CYRILLIC SMALL LETTER DZHE
   0x48A,    0x94,  // CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
   0x48B,    0xB4,  // CYRILLIC SMALL LETTER SHORT I WITH TAIL
   0x48C,    0x93,  // CYRILLIC CAPITAL LETTER SEMISOFT SIGN
   0x48D,    0xB3,  // CYRILLIC SMALL LETTER SEMISOFT SIGN
   0x48E,    0x86,  // CYRILLIC CAPITAL LETTER ER WITH TICK
   0x48F,    0xA6,  // CYRILLIC SMALL LETTER ER WITH TICK
   0x494,    0x83,  // CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
   0x495,    0xA3,  // CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
   0x49A,    0x89,  // CYRILLIC CAPITAL LETTER KA WITH DESCENDER
   0x49B,    0xA9,  // CYRILLIC SMALL LETTER KA WITH DESCENDER
   0x49E,    0x8B,  // CYRILLIC CAPITAL LETTER KA WITH STROKE
   0x49F,    0xAB,  // CYRILLIC SMALL LETTER KA WITH STROKE
   0x4A2,    0x8D,  // CYRILLIC CAPITAL LETTER EN WITH DESCENDER
   0x4A3,    0xAD,  // CYRILLIC SMALL LETTER EN WITH DESCENDER
   0x4A6,    0x80,  // CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
   0x4A7,    0xA0,  // CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
   0x4A8,    0x97,  // CYRILLIC CAPITAL LETTER ABKHASIAN HA
   0x4A9,    0xB7,  // CYRILLIC SMALL LETTER ABKHASIAN HA
   0x4AC,    0x82,  // CYRILLIC CAPITAL LETTER TE WITH DESCENDER
   0x4AD,    0xA2,  // CYRILLIC SMALL LETTER TE WITH DESCENDER
   0x4B2,    0x95,  // CYRILLIC CAPITAL LETTER HA WITH DESCENDER
   0x4B3,    0xB5,  // CYRILLIC SMALL LETTER HA WITH DESCENDER
   0x4B4,    0x81,  // CYRILLIC CAPITAL LIGATURE TE TSE
   0x4B5,    0xA1,  // CYRILLIC SMALL LIGATURE TE TSE
   0x4B6,    0x98,  // CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
   0x4B7,    0xB8,  // CYRILLIC SMALL LETTER CHE WITH DESCENDER
   0x4BA,    0x84,  // CYRILLIC CAPITAL LETTER SHHA
   0x4BB,    0xA4,  // CYRILLIC SMALL LETTER SHHA
   0x4BC,    0x91,  // CYRILLIC CAPITAL LETTER ABKHASIAN CHE
   0x4BD,    0xB1,  // CYRILLIC SMALL LETTER ABKHASIAN CHE
   0x4BE,    0x92,  // CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
   0x4BF,    0xB2,  // CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
   0x4C0,    0x0D,  // CYRILLIC LETTER PALOCHKA
   0x4C5,    0x8A,  // CYRILLIC CAPITAL LETTER EL WITH TAIL
   0x4C6,    0xAA,  // CYRILLIC SMALL LETTER EL WITH TAIL
   0x4C7,    0x8F,  // CYRILLIC CAPITAL LETTER EN WITH HOOK
   0x4C8,    0xAF,  // CYRILLIC SMALL LETTER EN WITH HOOK
   0x4CD,    0x88,  // CYRILLIC CAPITAL LETTER EM WITH TAIL
   0x4CE,    0xA8,  // CYRILLIC SMALL LETTER EM WITH TAIL
   0x4D8,    0x9A,  // CYRILLIC CAPITAL LETTER SCHWA
   0x4D9,    0xBA,  // CYRILLIC SMALL LETTER SCHWA
   0x4E0,    0x87,  // CYRILLIC CAPITAL LETTER ABKHASIAN DZE
   0x4E1,    0xA7,  // CYRILLIC SMALL LETTER ABKHASIAN DZE
   0x4E8,    0x90,  // CYRILLIC CAPITAL LETTER BARRED O
   0x4E9,    0xB0,  // CYRILLIC SMALL LETTER BARRED O
   0x512,    0x8C,  // CYRILLIC CAPITAL LETTER EL WITH HOOK
   0x513,    0xAC,  // CYRILLIC SMALL LETTER EL WITH HOOK
   0x51A,    0x51,  // CYRILLIC CAPITAL LETTER QA;   \CYRQ
   0x51B,    0x71,  // CYRILLIC SMALL LETTER QA;     \cyrq
   0x51C,    0x57,  // CYRILLIC CAPITAL LETTER WE;   \CYRW
   0x51D,    0x77,  // CYRILLIC SMALL LETTER WE;     \cyrw
   0x528,    0x99,  // CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK
   0x529,    0xB9,  // CYRILLIC SMALL LETTER EN WITH LEFT HOOK
  0x200C,    0x17,
  0x2010,    0x7F,
  0x2013,    0x15,
  0x2014,    0x16,
  0x2018,    0x60,
  0x2019,    0x27,
  0x201C,    0x10,
  0x201D,    0x11,
  0x201E,    0xBD,
  0x2116,    0x9D,
  0x2329,    0x0E,
  0x232A,    0x0F,
  0x2423,    0x20,
};

/* UCS -> LGR mapping table */
static unsigned short UCStoLGRenc[] = {
    /* from,  to */
    0xAB,    0x7B,
    0xBB,    0x7D,
   0x259,    0x1A,  // Latin Small Letter Schwa
   0x374,    0xFE,  // Greek Numeral Sign
   0x375,    0xFF,  // Greek Lower Numeral Sign
   0x37A,    0x7C,  // Greek Ypogegrammeni
   0x37E,    0x3F,  // Greek Question Mark
   0x384,    0x27,  // Greek Tonos
   0x386,    0xFD,  // Greek Capital Letter Alpha with Tonos
   0x387,    0x26,  // Greek Ano Teleia
   0x388,    0xC7,  // Greek Capital Letter Epsilon with Tonos
   0x389,    0x9F,  // Greek Capital Letter Eta with Tonos
   0x38A,    0x9B,  // Greek Capital Letter Iota with Tonos
   0x38C,    0x97,  // Greek Capital Letter Omicron with Tonos
   0x390,    0xF2,  // Greek Small Letter Iota with Dialytika and Tonos

   0x391,    0x0C,  // Greek Capital Letter Alpha
//   0x391,    0x41,  // Greek Capital Letter Alpha
   0x392,    0x42,  // Greek Capital Letter Beta
   0x393,    0x47,  // Greek Capital Letter Gamma
   0x394,    0x44,  // Greek Capital Letter Delta
   0x395,    0x45,  // Greek Capital Letter Epsilon
   0x396,    0x5A,  // Greek Capital Letter Zeta
   0x397,    0x48,  // Greek Capital Letter Eta
   0x398,    0x4A,  // Greek Capital Letter Theta
   0x399,    0x49,  // Greek Capital Letter Iota
   0x39A,    0x4B,  // Greek Capital Letter Kappa
   0x39B,    0x4C,  // Greek Capital Letter Lamda
   0x39C,    0x4D,  // Greek Capital Letter Mu
   0x39D,    0x4E,  // Greek Capital Letter Nu
   0x39E,    0x58,  // Greek Capital Letter Xi
   0x39F,    0x4F,  // Greek Capital Letter Omicron
   0x3A0,    0x50,  // Greek Capital Letter Pi
   0x3A1,    0x52,  // Greek Capital Letter Rho
   0x3A3,    0x53,  // Greek Capital Letter Sigma
   0x3A4,    0x54,  // Greek Capital Letter Tau
   0x3A5,    0x55,  // Greek Capital Letter Upsilon
   0x3A6,    0x46,  // Greek Capital Letter Phi
   0x3A7,    0x51,  // Greek Capital Letter Chi
   0x3A8,    0x59,  // Greek Capital Letter Psi
   0x3A9,    0x57,  // Greek Capital Letter Omega

   0x3AA,    0xDB,  // Greek Capital Letter Iota with Dialytika
//   0x3AB,    0x13,  // Greek Capital Letter Upsilon with Dialytika
   0x3AB,    0xDF,  // Greek Capital Letter Upsilon with Dialytika
   0x3AC,    0x88,  // Greek Small Letter Alpha with Tonos
   0x3AD,    0xE8,  // Greek Small Letter Epsilon with Tonos
   0x3AE,    0xA0,  // Greek Small Letter Eta with Tonos
   0x3AF,    0xD0,  // Greek Small Letter Iota with Tonos
   0x3B0,    0xF6,  // Greek Small Letter Upsilon with Dialytika and Tonos

   0x3B1,    0x0E,  // Greek Small Letter Alpha
//   0x3B1,    0x61,  // Greek Small Letter Alpha
   0x3B2,    0x62,  // Greek Small Letter Beta
   0x3B3,    0x67,  // Greek Small Letter Gamma
   0x3B4,    0x64,  // Greek Small Letter Delta
   0x3B5,    0x65,  // Greek Small Letter Epsilon
   0x3B6,    0x7A,  // Greek Small Letter Zeta
   0x3B7,    0x68,  // Greek Small Letter Eta
   0x3B8,    0x6A,  // Greek Small Letter Theta
   0x3B9,    0x69,  // Greek Small Letter Iota
   0x3BA,    0x6B,  // Greek Small Letter Kappa
   0x3BB,    0x6C,  // Greek Small Letter Lamda
   0x3BC,    0x6D,  // Greek Small Letter Mu
   0x3BD,    0x6E,  // Greek Small Letter Nu
   0x3BE,    0x78,  // Greek Small Letter Xi
   0x3BF,    0x6F,  // Greek Small Letter Omicron
   0x3C0,    0x70,  // Greek Small Letter Pi
   0x3C1,    0x72,  // Greek Small Letter Rho
   0x3C2,    0x63,  // Greek Small Letter Final Sigma
   0x3C3,    0x73,  // Greek Small Letter Sigma
   0x3C4,    0x74,  // Greek Small Letter Tau
   0x3C5,    0x75,  // Greek Small Letter Upsilon
   0x3C6,    0x66,  // Greek Small Letter Phi
   0x3C7,    0x71,  // Greek Small Letter Chi
   0x3C8,    0x79,  // Greek Small Letter Psi
   0x3C9,    0x77,  // Greek Small Letter Omega

   0x3CA,    0xF0,  // Greek Small Letter Iota with Dialytika
//   0x3CB,    0x0F,  // Greek Small Letter Upsilon with Dialytika
   0x3CB,    0xF4,  // Greek Small Letter Upsilon with Dialytika
   0x3CC,    0xEC,  // Greek Small Letter Omicron with Tonos
   0x3CD,    0xD4,  // Greek Small Letter Upsilon with Tonos
   0x3CE,    0xB8,  // Greek Small Letter Omega with Tonos
   0x3D8,    0x15,  // Greek Letter Archaic Koppa
   0x3D9,    0x13,  // Greek Small Letter Archaic Koppa
   0x3DA,    0x16,  // Greek Letter Stigma
   0x3DB,    0x06,  // Greek Small Letter Stigma
   0x3DD,    0x93,  // Greek Small Letter Digamma
   0x3DF,    0x12,  // Greek Small Letter Koppa
   0x3E0,    0x17,  // Greek Letter Sampi
   0x3E1,    0x1B,  // Greek Small Letter Sampi

  0x1F00,    0x82,  // Greek Small Letter Alpha with Psili
  0x1F01,    0x81,  // Greek Small Letter Alpha with Dasia
  0x1F02,    0x8B,  // Greek Small Letter Alpha with Psili and Varia
  0x1F03,    0x83,  // Greek Small Letter Alpha with Dasia and Varia
  0x1F04,    0x8A,  // Greek Small Letter Alpha with Psili and Oxia
  0x1F05,    0x89,  // Greek Small Letter Alpha with Dasia and Oxia
  0x1F06,    0x92,  // Greek Small Letter Alpha with Psili and Perispomeni
  0x1F07,    0x91,  // Greek Small Letter Alpha with Dasia and Perispomeni
  0x1F10,    0xE2,  // Greek Small Letter Epsilon with Psili
  0x1F11,    0xE1,  // Greek Small Letter Epsilon with Dasia
  0x1F12,    0xEB,  // Greek Small Letter Epsilon with Psili and Varia
  0x1F13,    0xE3,  // Greek Small Letter Epsilon with Dasia and Varia
  0x1F14,    0xEA,  // Greek Small Letter Epsilon with Psili and Oxia
  0x1F15,    0xE9,  // Greek Small Letter Epsilon with Dasia and Oxia
  0x1F20,    0x9A,  // Greek Small Letter Eta with Psili
  0x1F21,    0x99,  // Greek Small Letter Eta with Dasia
  0x1F22,    0xAB,  // Greek Small Letter Eta with Psili and Varia
  0x1F23,    0xA3,  // Greek Small Letter Eta with Dasia and Varia
  0x1F24,    0xA2,  // Greek Small Letter Eta with Psili and Oxia
  0x1F25,    0xA1,  // Greek Small Letter Eta with Dasia and Oxia
  0x1F26,    0xAA,  // Greek Small Letter Eta with Psili and Perispomeni
  0x1F27,    0xA9,  // Greek Small Letter Eta with Dasia and Perispomeni
  0x1F30,    0xCA,  // Greek Small Letter Iota with Psili
  0x1F31,    0xC9,  // Greek Small Letter Iota with Dasia
  0x1F32,    0xD3,  // Greek Small Letter Iota with Psili and Varia
  0x1F33,    0xCB,  // Greek Small Letter Iota with Dasia and Varia
  0x1F34,    0xD2,  // Greek Small Letter Iota with Psili and Oxia
  0x1F35,    0xD1,  // Greek Small Letter Iota with Dasia and Oxia
  0x1F36,    0xDA,  // Greek Small Letter Iota with Psili and Perispomeni
  0x1F37,    0xD9,  // Greek Small Letter Iota with Dasia and Perispomeni
  0x1F40,    0xE6,  // Greek Small Letter Omicron with Psili
  0x1F41,    0xE5,  // Greek Small Letter Omicron with Dasia
  0x1F42,    0xEF,  // Greek Small Letter Omicron with Psili and Varia
  0x1F43,    0xE7,  // Greek Small Letter Omicron with Dasia and Varia
  0x1F44,    0xEE,  // Greek Small Letter Omicron with Psili and Oxia
  0x1F45,    0xED,  // Greek Small Letter Omicron with Dasia and Oxia
  0x1F50,    0xCE,  // Greek Small Letter Upsilon with Psili
  0x1F51,    0xCD,  // Greek Small Letter Upsilon with Dasia
  0x1F52,    0xD7,  // Greek Small Letter Upsilon with Psili and Varia
  0x1F53,    0xCF,  // Greek Small Letter Upsilon with Dasia and Varia
  0x1F54,    0xD6,  // Greek Small Letter Upsilon with Psili and Oxia
  0x1F55,    0xD5,  // Greek Small Letter Upsilon with Dasia and Oxia
  0x1F56,    0xDE,  // Greek Small Letter Upsilon with Psili and Perispomeni
  0x1F57,    0xDD,  // Greek Small Letter Upsilon with Dasia and Perispomeni
  0x1F60,    0xB2,  // Greek Small Letter Omega with Psili
  0x1F61,    0xB1,  // Greek Small Letter Omega with Dasia
  0x1F62,    0xBB,  // Greek Small Letter Omega with Psili and Varia
  0x1F63,    0xB3,  // Greek Small Letter Omega with Dasia and Varia
  0x1F64,    0xBA,  // Greek Small Letter Omega with Psili and Oxia
  0x1F65,    0xB9,  // Greek Small Letter Omega with Dasia and Oxia
  0x1F66,    0xC2,  // Greek Small Letter Omega with Psili and Perispomeni
  0x1F67,    0xC1,  // Greek Small Letter Omega with Dasia and Perispomeni
  0x1F70,    0x80,  // Greek Small Letter Alpha with Varia
  0x1F71,    0x88,  // Greek Small Letter Alpha with Oxia
  0x1F72,    0xE0,  // Greek Small Letter Epsilon with Varia
  0x1F73,    0xE8,  // Greek Small Letter Epsilon with Oxia
  0x1F74,    0x98,  // Greek Small Letter Eta with Varia
  0x1F75,    0xA0,  // Greek Small Letter Eta with Oxia
  0x1F76,    0xC8,  // Greek Small Letter Iota with Varia
  0x1F77,    0xD0,  // Greek Small Letter Iota with Oxia
  0x1F78,    0xE4,  // Greek Small Letter Omicron with Varia
  0x1F79,    0xEC,  // Greek Small Letter Omicron with Oxia
  0x1F7A,    0xCC,  // Greek Small Letter Upsilon with Varia
  0x1F7B,    0xD4,  // Greek Small Letter Upsilon with Oxia
  0x1F7C,    0xB0,  // Greek Small Letter Omega with Varia
  0x1F7D,    0xB8,  // Greek Small Letter Omega with Oxia
  0x1F80,    0x86,  // Greek Small Letter Alpha with Psili and Ypogegrammeni
  0x1F81,    0x85,  // Greek Small Letter Alpha with Dasia and Ypogegrammeni
  0x1F82,    0x8F,  // Greek Small Letter Alpha with Psili and Varia and Ypogegrammeni
  0x1F83,    0x87,  // Greek Small Letter Alpha with Dasia and Varia and Ypogegrammeni
  0x1F84,    0x8E,  // Greek Small Letter Alpha with Psili and Oxia and Ypogegrammeni
  0x1F85,    0x8D,  // Greek Small Letter Alpha with Dasia and Oxia and Ypogegrammeni
  0x1F86,    0x96,  // Greek Small Letter Alpha with Psili and Perispomeni and Ypogegrammeni
  0x1F87,    0x95,  // Greek Small Letter Alpha with Dasia and Perispomeni and Ypogegrammeni
  0x1F90,    0x9E,  // Greek Small Letter Eta with Psili and Ypogegrammeni
  0x1F91,    0x9D,  // Greek Small Letter Eta with Dasia and Ypogegrammeni
  0x1F92,    0xAF,  // Greek Small Letter Eta with Psili and Varia and Ypogegrammeni
  0x1F93,    0xA7,  // Greek Small Letter Eta with Dasia and Varia and Ypogegrammeni
  0x1F94,    0xA6,  // Greek Small Letter Eta with Psili and Oxia and Ypogegrammeni
  0x1F95,    0xA5,  // Greek Small Letter Eta with Dasia and Oxia and Ypogegrammeni
  0x1F96,    0xAE,  // Greek Small Letter Eta with Psili and Perispomeni and Ypogegrammeni
  0x1F97,    0xAD,  // Greek Small Letter Eta with Dasia and Perispomeni and Ypogegrammeni
  0x1FA0,    0xB6,  // Greek Small Letter Omega with Psili and Ypogegrammeni
  0x1FA1,    0xB5,  // Greek Small Letter Omega with Dasia and Ypogegrammeni
  0x1FA2,    0xBF,  // Greek Small Letter Omega with Psili and Varia and Ypogegrammeni
  0x1FA3,    0xB7,  // Greek Small Letter Omega with Dasia and Varia and Ypogegrammeni
  0x1FA4,    0xBE,  // Greek Small Letter Omega with Psili and Oxia and Ypogegrammeni
  0x1FA5,    0xBD,  // Greek Small Letter Omega with Dasia and Oxia and Ypogegrammeni
  0x1FA6,    0xC6,  // Greek Small Letter Omega with Psili and Perispomeni and Ypogegrammeni
  0x1FA7,    0xC5,  // Greek Small Letter Omega with Dasia and Perispomeni and Ypogegrammeni
  0x1FB2,    0x84,  // Greek Small Letter Alpha with Varia and Ypogegrammeni
  0x1FB3,    0xF8,  // Greek Small Letter Alpha with Ypogegrammeni
  0x1FB4,    0x8C,  // Greek Small Letter Alpha with Oxia and Ypogegrammeni
  0x1FB6,    0x90,  // Greek Small Letter Alpha with Perispomeni
  0x1FB7,    0x94,  // Greek Small Letter Alpha with Perispomeni and Ypogegrammeni
  0x1FBB,    0xFD,  // Greek Capital Letter Alpha with Oxia
  0x1FBC,    0x09,  // Greek Capital Letter Alpha with Prosgegrammeni
  0x1FBD,    0x3E,  // Greek Koronis
  0x1FBE,    0x08,  // Greek Prosgegrammeni
  0x1FBF,    0x3E,  // Greek Psili
  0x1FC0,    0x7E,  // Greek Perispomeni
  0x1FC1,    0x20,  // Greek Dialytika and Perispomeni
  0x1FC2,    0x9C,  // Greek Small Letter Eta with Varia and Ypogegrammeni
  0x1FC3,    0xF9,  // Greek Small Letter Eta with Ypogegrammeni
  0x1FC4,    0xA4,  // Greek Small Letter Eta with Oxia and Ypogegrammeni
  0x1FC6,    0xA8,  // Greek Small Letter Eta with Perispomeni
  0x1FC7,    0xAC,  // Greek Small Letter Eta with Perispomeni and Ypogegrammeni
  0x1FC9,    0xC7,  // Greek Capital Letter Epsilon with Oxia
  0x1FCB,    0x9F,  // Greek Capital Letter Eta with Oxia
  0x1FCC,    0x0A,  // Greek Capital Letter Eta with Prosgegrammeni
  0x1FCD,    0x5F,  // Greek Psili and Varia
  0x1FCE,    0x5E,  // Greek Psili and Oxia
  0x1FCF,    0x5C,  // Greek Psili and Perispomeni
  0x1FD2,    0xF1,  // Greek Small Letter Iota with Dialytika and Varia
  0x1FD3,    0xF2,  // Greek Small Letter Iota with Dialytika and Oxia
  0x1FD6,    0xD8,  // Greek Small Letter Iota with Perispomeni
  0x1FD7,    0xF3,  // Greek Small Letter Iota with Dialytika and Perispomeni
  0x1FDB,    0x9B,  // Greek Capital Letter Iota with Oxia
  0x1FDD,    0x43,  // Greek Dasia and Varia
  0x1FDE,    0x56,  // Greek Dasia and Oxia
  0x1FDF,    0x40,  // Greek Dasia and Perispomeni
  0x1FE2,    0xF5,  // Greek Small Letter Upsilon with Dialytika and Varia
  0x1FE3,    0xF6,  // Greek Small Letter Upsilon with Dialytika and Oxia
  0x1FE4,    0xFC,  // Greek Small Letter Rho with Psili
  0x1FE5,    0xFB,  // Greek Small Letter Rho with Dasia
  0x1FE6,    0xDC,  // Greek Small Letter Upsilon with Perispomeni
  0x1FE7,    0xF7,  // Greek Small Letter Upsilon with Dialytika and Perispomeni
  0x1FED,    0x23,  // Greek Dialytika and Varia
  0x1FEE,    0x24,  // Greek Dialytika and Oxia
  0x1FEF,    0x60,  // Greek Varia
  0x1FF2,    0xB4,  // Greek Small Letter Omega with Varia and Ypogegrammeni
  0x1FF3,    0xFA,  // Greek Small Letter Omega with Ypogegrammeni
  0x1FF4,    0xBC,  // Greek Small Letter Omega with Oxia and Ypogegrammeni
  0x1FF6,    0xC0,  // Greek Small Letter Omega with Perispomeni
  0x1FF7,    0xC4,  // Greek Small Letter Omega with Perispomeni and Ypogegrammeni
  0x1FF9,    0x97,  // Greek Capital Letter Omicron with Oxia
  0x1FFC,    0x0B,  // Greek Capital Letter Omega with Prosgegrammeni
  0x1FFD,    0x27,  // Greek Oxia
  0x1FFE,    0x3C,  // Greek Dasia
  0x2013,    0x00,
  0x2014,    0x7F,
  0x2018,    0x1C,
  0x2019,    0x1D,
  0x2030,    0x19,
  0x20AC,    0x18,
  0x2126,    0x57,
};

#endif /* TEX8BENC_H */

#ifdef __cplusplus
}
#endif

